<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

class Google_Service_Dialogflow_GoogleCloudDialogflowCxV3TransitionRoute extends Google_Model
{
  public $condition;
  public $intent;
  public $name;
  public $targetFlow;
  public $targetPage;
  protected $triggerFulfillmentType = 'Google_Service_Dialogflow_GoogleCloudDialogflowCxV3Fulfillment';
  protected $triggerFulfillmentDataType = '';

  public function setCondition($condition)
  {
    $this->condition = $condition;
  }
  public function getCondition()
  {
    return $this->condition;
  }
  public function setIntent($intent)
  {
    $this->intent = $intent;
  }
  public function getIntent()
  {
    return $this->intent;
  }
  public function setName($name)
  {
    $this->name = $name;
  }
  public function getName()
  {
    return $this->name;
  }
  public function setTargetFlow($targetFlow)
  {
    $this->targetFlow = $targetFlow;
  }
  public function getTargetFlow()
  {
    return $this->targetFlow;
  }
  public function setTargetPage($targetPage)
  {
    $this->targetPage = $targetPage;
  }
  public function getTargetPage()
  {
    return $this->targetPage;
  }
  /**
   * @param Google_Service_Dialogflow_GoogleCloudDialogflowCxV3Fulfillment
   */
  public function setTriggerFulfillment(Google_Service_Dialogflow_GoogleCloudDialogflowCxV3Fulfillment $triggerFulfillment)
  {
    $this->triggerFulfillment = $triggerFulfillment;
  }
  /**
   * @return Google_Service_Dialogflow_GoogleCloudDialogflowCxV3Fulfillment
   */
  public function getTriggerFulfillment()
  {
    return $this->triggerFulfillment;
  }
}
