<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* AppVulnerabilityTask File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright © Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Beta\Microsoft\Graph\Model;

/**
* AppVulnerabilityTask class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright © Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class AppVulnerabilityTask extends DeviceAppManagementTask
{
    /**
    * Gets the appName
    * The app name.
    *
    * @return string The appName
    */
    public function getAppName()
    {
        if (array_key_exists("appName", $this->_propDict)) {
            return $this->_propDict["appName"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the appName
    * The app name.
    *
    * @param string $val The appName
    *
    * @return AppVulnerabilityTask
    */
    public function setAppName($val)
    {
        $this->_propDict["appName"] = $val;
        return $this;
    }
    
    /**
    * Gets the appPublisher
    * The app publisher.
    *
    * @return string The appPublisher
    */
    public function getAppPublisher()
    {
        if (array_key_exists("appPublisher", $this->_propDict)) {
            return $this->_propDict["appPublisher"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the appPublisher
    * The app publisher.
    *
    * @param string $val The appPublisher
    *
    * @return AppVulnerabilityTask
    */
    public function setAppPublisher($val)
    {
        $this->_propDict["appPublisher"] = $val;
        return $this;
    }
    
    /**
    * Gets the appVersion
    * The app version.
    *
    * @return string The appVersion
    */
    public function getAppVersion()
    {
        if (array_key_exists("appVersion", $this->_propDict)) {
            return $this->_propDict["appVersion"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the appVersion
    * The app version.
    *
    * @param string $val The appVersion
    *
    * @return AppVulnerabilityTask
    */
    public function setAppVersion($val)
    {
        $this->_propDict["appVersion"] = $val;
        return $this;
    }
    
    /**
    * Gets the insights
    * Information about the mitigation.
    *
    * @return string The insights
    */
    public function getInsights()
    {
        if (array_key_exists("insights", $this->_propDict)) {
            return $this->_propDict["insights"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the insights
    * Information about the mitigation.
    *
    * @param string $val The insights
    *
    * @return AppVulnerabilityTask
    */
    public function setInsights($val)
    {
        $this->_propDict["insights"] = $val;
        return $this;
    }
    
    /**
    * Gets the managedDeviceCount
    * The number of vulnerable devices.
    *
    * @return int The managedDeviceCount
    */
    public function getManagedDeviceCount()
    {
        if (array_key_exists("managedDeviceCount", $this->_propDict)) {
            return $this->_propDict["managedDeviceCount"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the managedDeviceCount
    * The number of vulnerable devices.
    *
    * @param int $val The managedDeviceCount
    *
    * @return AppVulnerabilityTask
    */
    public function setManagedDeviceCount($val)
    {
        $this->_propDict["managedDeviceCount"] = intval($val);
        return $this;
    }
    
    /**
    * Gets the mitigationType
    * The mitigation type.
    *
    * @return AppVulnerabilityTaskMitigationType The mitigationType
    */
    public function getMitigationType()
    {
        if (array_key_exists("mitigationType", $this->_propDict)) {
            if (is_a($this->_propDict["mitigationType"], "Beta\Microsoft\Graph\Model\AppVulnerabilityTaskMitigationType")) {
                return $this->_propDict["mitigationType"];
            } else {
                $this->_propDict["mitigationType"] = new AppVulnerabilityTaskMitigationType($this->_propDict["mitigationType"]);
                return $this->_propDict["mitigationType"];
            }
        }
        return null;
    }
    
    /**
    * Sets the mitigationType
    * The mitigation type.
    *
    * @param AppVulnerabilityTaskMitigationType $val The mitigationType
    *
    * @return AppVulnerabilityTask
    */
    public function setMitigationType($val)
    {
        $this->_propDict["mitigationType"] = $val;
        return $this;
    }
    
    /**
    * Gets the mobileAppCount
    * The number of vulnerable mobile apps.
    *
    * @return int The mobileAppCount
    */
    public function getMobileAppCount()
    {
        if (array_key_exists("mobileAppCount", $this->_propDict)) {
            return $this->_propDict["mobileAppCount"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the mobileAppCount
    * The number of vulnerable mobile apps.
    *
    * @param int $val The mobileAppCount
    *
    * @return AppVulnerabilityTask
    */
    public function setMobileAppCount($val)
    {
        $this->_propDict["mobileAppCount"] = intval($val);
        return $this;
    }
    
    /**
    * Gets the remediation
    * The remediation steps.
    *
    * @return string The remediation
    */
    public function getRemediation()
    {
        if (array_key_exists("remediation", $this->_propDict)) {
            return $this->_propDict["remediation"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the remediation
    * The remediation steps.
    *
    * @param string $val The remediation
    *
    * @return AppVulnerabilityTask
    */
    public function setRemediation($val)
    {
        $this->_propDict["remediation"] = $val;
        return $this;
    }
    

     /** 
     * Gets the managedDevices
    * The vulnerable managed devices.
     *
     * @return array The managedDevices
     */
    public function getManagedDevices()
    {
        if (array_key_exists("managedDevices", $this->_propDict)) {
           return $this->_propDict["managedDevices"];
        } else {
            return null;
        }
    }
    
    /** 
    * Sets the managedDevices
    * The vulnerable managed devices.
    *
    * @param AppVulnerabilityManagedDevice $val The managedDevices
    *
    * @return AppVulnerabilityTask
    */
    public function setManagedDevices($val)
    {
		$this->_propDict["managedDevices"] = $val;
        return $this;
    }
    

     /** 
     * Gets the mobileApps
    * The vulnerable mobile apps.
     *
     * @return array The mobileApps
     */
    public function getMobileApps()
    {
        if (array_key_exists("mobileApps", $this->_propDict)) {
           return $this->_propDict["mobileApps"];
        } else {
            return null;
        }
    }
    
    /** 
    * Sets the mobileApps
    * The vulnerable mobile apps.
    *
    * @param AppVulnerabilityMobileApp $val The mobileApps
    *
    * @return AppVulnerabilityTask
    */
    public function setMobileApps($val)
    {
		$this->_propDict["mobileApps"] = $val;
        return $this;
    }
    
}