<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* MalwareStateForWindowsDevice File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright © Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Beta\Microsoft\Graph\Model;

/**
* MalwareStateForWindowsDevice class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright © Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class MalwareStateForWindowsDevice extends Entity
{
    /**
    * Gets the detectionCount
    * Number of times the malware is detected
    *
    * @return int The detectionCount
    */
    public function getDetectionCount()
    {
        if (array_key_exists("detectionCount", $this->_propDict)) {
            return $this->_propDict["detectionCount"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the detectionCount
    * Number of times the malware is detected
    *
    * @param int $val The detectionCount
    *
    * @return MalwareStateForWindowsDevice
    */
    public function setDetectionCount($val)
    {
        $this->_propDict["detectionCount"] = intval($val);
        return $this;
    }
    
    /**
    * Gets the deviceName
    * Device name
    *
    * @return string The deviceName
    */
    public function getDeviceName()
    {
        if (array_key_exists("deviceName", $this->_propDict)) {
            return $this->_propDict["deviceName"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the deviceName
    * Device name
    *
    * @param string $val The deviceName
    *
    * @return MalwareStateForWindowsDevice
    */
    public function setDeviceName($val)
    {
        $this->_propDict["deviceName"] = $val;
        return $this;
    }
    
    /**
    * Gets the executionState
    * Execution status of the malware like blocked/executing etc
    *
    * @return WindowsMalwareExecutionState The executionState
    */
    public function getExecutionState()
    {
        if (array_key_exists("executionState", $this->_propDict)) {
            if (is_a($this->_propDict["executionState"], "Beta\Microsoft\Graph\Model\WindowsMalwareExecutionState")) {
                return $this->_propDict["executionState"];
            } else {
                $this->_propDict["executionState"] = new WindowsMalwareExecutionState($this->_propDict["executionState"]);
                return $this->_propDict["executionState"];
            }
        }
        return null;
    }
    
    /**
    * Sets the executionState
    * Execution status of the malware like blocked/executing etc
    *
    * @param WindowsMalwareExecutionState $val The executionState
    *
    * @return MalwareStateForWindowsDevice
    */
    public function setExecutionState($val)
    {
        $this->_propDict["executionState"] = $val;
        return $this;
    }
    
    /**
    * Gets the initialDetectionDateTime
    * Initial detection datetime of the malware
    *
    * @return \DateTime The initialDetectionDateTime
    */
    public function getInitialDetectionDateTime()
    {
        if (array_key_exists("initialDetectionDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["initialDetectionDateTime"], "\DateTime")) {
                return $this->_propDict["initialDetectionDateTime"];
            } else {
                $this->_propDict["initialDetectionDateTime"] = new \DateTime($this->_propDict["initialDetectionDateTime"]);
                return $this->_propDict["initialDetectionDateTime"];
            }
        }
        return null;
    }
    
    /**
    * Sets the initialDetectionDateTime
    * Initial detection datetime of the malware
    *
    * @param \DateTime $val The initialDetectionDateTime
    *
    * @return MalwareStateForWindowsDevice
    */
    public function setInitialDetectionDateTime($val)
    {
        $this->_propDict["initialDetectionDateTime"] = $val;
        return $this;
    }
    
    /**
    * Gets the lastStateChangeDateTime
    * The last time this particular threat was changed
    *
    * @return \DateTime The lastStateChangeDateTime
    */
    public function getLastStateChangeDateTime()
    {
        if (array_key_exists("lastStateChangeDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["lastStateChangeDateTime"], "\DateTime")) {
                return $this->_propDict["lastStateChangeDateTime"];
            } else {
                $this->_propDict["lastStateChangeDateTime"] = new \DateTime($this->_propDict["lastStateChangeDateTime"]);
                return $this->_propDict["lastStateChangeDateTime"];
            }
        }
        return null;
    }
    
    /**
    * Sets the lastStateChangeDateTime
    * The last time this particular threat was changed
    *
    * @param \DateTime $val The lastStateChangeDateTime
    *
    * @return MalwareStateForWindowsDevice
    */
    public function setLastStateChangeDateTime($val)
    {
        $this->_propDict["lastStateChangeDateTime"] = $val;
        return $this;
    }
    
    /**
    * Gets the threatState
    * Threat status of the malware like cleaned/quarantined/allowed etc
    *
    * @return WindowsMalwareThreatState The threatState
    */
    public function getThreatState()
    {
        if (array_key_exists("threatState", $this->_propDict)) {
            if (is_a($this->_propDict["threatState"], "Beta\Microsoft\Graph\Model\WindowsMalwareThreatState")) {
                return $this->_propDict["threatState"];
            } else {
                $this->_propDict["threatState"] = new WindowsMalwareThreatState($this->_propDict["threatState"]);
                return $this->_propDict["threatState"];
            }
        }
        return null;
    }
    
    /**
    * Sets the threatState
    * Threat status of the malware like cleaned/quarantined/allowed etc
    *
    * @param WindowsMalwareThreatState $val The threatState
    *
    * @return MalwareStateForWindowsDevice
    */
    public function setThreatState($val)
    {
        $this->_propDict["threatState"] = $val;
        return $this;
    }
    
}