<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* WindowsDeviceMalwareState File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright © Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Beta\Microsoft\Graph\Model;

/**
* WindowsDeviceMalwareState class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright © Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class WindowsDeviceMalwareState extends Entity
{
    /**
    * Gets the additionalInformationUrl
    * Information URL to learn more about the malware
    *
    * @return string The additionalInformationUrl
    */
    public function getAdditionalInformationUrl()
    {
        if (array_key_exists("additionalInformationUrl", $this->_propDict)) {
            return $this->_propDict["additionalInformationUrl"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the additionalInformationUrl
    * Information URL to learn more about the malware
    *
    * @param string $val The additionalInformationUrl
    *
    * @return WindowsDeviceMalwareState
    */
    public function setAdditionalInformationUrl($val)
    {
        $this->_propDict["additionalInformationUrl"] = $val;
        return $this;
    }
    
    /**
    * Gets the category
    * Category of the malware
    *
    * @return WindowsMalwareCategory The category
    */
    public function getCategory()
    {
        if (array_key_exists("category", $this->_propDict)) {
            if (is_a($this->_propDict["category"], "Beta\Microsoft\Graph\Model\WindowsMalwareCategory")) {
                return $this->_propDict["category"];
            } else {
                $this->_propDict["category"] = new WindowsMalwareCategory($this->_propDict["category"]);
                return $this->_propDict["category"];
            }
        }
        return null;
    }
    
    /**
    * Sets the category
    * Category of the malware
    *
    * @param WindowsMalwareCategory $val The category
    *
    * @return WindowsDeviceMalwareState
    */
    public function setCategory($val)
    {
        $this->_propDict["category"] = $val;
        return $this;
    }
    
    /**
    * Gets the detectionCount
    * Number of times the malware is detected
    *
    * @return int The detectionCount
    */
    public function getDetectionCount()
    {
        if (array_key_exists("detectionCount", $this->_propDict)) {
            return $this->_propDict["detectionCount"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the detectionCount
    * Number of times the malware is detected
    *
    * @param int $val The detectionCount
    *
    * @return WindowsDeviceMalwareState
    */
    public function setDetectionCount($val)
    {
        $this->_propDict["detectionCount"] = intval($val);
        return $this;
    }
    
    /**
    * Gets the displayName
    * Malware name
    *
    * @return string The displayName
    */
    public function getDisplayName()
    {
        if (array_key_exists("displayName", $this->_propDict)) {
            return $this->_propDict["displayName"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the displayName
    * Malware name
    *
    * @param string $val The displayName
    *
    * @return WindowsDeviceMalwareState
    */
    public function setDisplayName($val)
    {
        $this->_propDict["displayName"] = $val;
        return $this;
    }
    
    /**
    * Gets the executionState
    * Execution status of the malware like blocked/executing etc
    *
    * @return WindowsMalwareExecutionState The executionState
    */
    public function getExecutionState()
    {
        if (array_key_exists("executionState", $this->_propDict)) {
            if (is_a($this->_propDict["executionState"], "Beta\Microsoft\Graph\Model\WindowsMalwareExecutionState")) {
                return $this->_propDict["executionState"];
            } else {
                $this->_propDict["executionState"] = new WindowsMalwareExecutionState($this->_propDict["executionState"]);
                return $this->_propDict["executionState"];
            }
        }
        return null;
    }
    
    /**
    * Sets the executionState
    * Execution status of the malware like blocked/executing etc
    *
    * @param WindowsMalwareExecutionState $val The executionState
    *
    * @return WindowsDeviceMalwareState
    */
    public function setExecutionState($val)
    {
        $this->_propDict["executionState"] = $val;
        return $this;
    }
    
    /**
    * Gets the initialDetectionDateTime
    * Initial detection datetime of the malware
    *
    * @return \DateTime The initialDetectionDateTime
    */
    public function getInitialDetectionDateTime()
    {
        if (array_key_exists("initialDetectionDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["initialDetectionDateTime"], "\DateTime")) {
                return $this->_propDict["initialDetectionDateTime"];
            } else {
                $this->_propDict["initialDetectionDateTime"] = new \DateTime($this->_propDict["initialDetectionDateTime"]);
                return $this->_propDict["initialDetectionDateTime"];
            }
        }
        return null;
    }
    
    /**
    * Sets the initialDetectionDateTime
    * Initial detection datetime of the malware
    *
    * @param \DateTime $val The initialDetectionDateTime
    *
    * @return WindowsDeviceMalwareState
    */
    public function setInitialDetectionDateTime($val)
    {
        $this->_propDict["initialDetectionDateTime"] = $val;
        return $this;
    }
    
    /**
    * Gets the lastStateChangeDateTime
    * The last time this particular threat was changed
    *
    * @return \DateTime The lastStateChangeDateTime
    */
    public function getLastStateChangeDateTime()
    {
        if (array_key_exists("lastStateChangeDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["lastStateChangeDateTime"], "\DateTime")) {
                return $this->_propDict["lastStateChangeDateTime"];
            } else {
                $this->_propDict["lastStateChangeDateTime"] = new \DateTime($this->_propDict["lastStateChangeDateTime"]);
                return $this->_propDict["lastStateChangeDateTime"];
            }
        }
        return null;
    }
    
    /**
    * Sets the lastStateChangeDateTime
    * The last time this particular threat was changed
    *
    * @param \DateTime $val The lastStateChangeDateTime
    *
    * @return WindowsDeviceMalwareState
    */
    public function setLastStateChangeDateTime($val)
    {
        $this->_propDict["lastStateChangeDateTime"] = $val;
        return $this;
    }
    
    /**
    * Gets the severity
    * Severity of the malware
    *
    * @return WindowsMalwareSeverity The severity
    */
    public function getSeverity()
    {
        if (array_key_exists("severity", $this->_propDict)) {
            if (is_a($this->_propDict["severity"], "Beta\Microsoft\Graph\Model\WindowsMalwareSeverity")) {
                return $this->_propDict["severity"];
            } else {
                $this->_propDict["severity"] = new WindowsMalwareSeverity($this->_propDict["severity"]);
                return $this->_propDict["severity"];
            }
        }
        return null;
    }
    
    /**
    * Sets the severity
    * Severity of the malware
    *
    * @param WindowsMalwareSeverity $val The severity
    *
    * @return WindowsDeviceMalwareState
    */
    public function setSeverity($val)
    {
        $this->_propDict["severity"] = $val;
        return $this;
    }
    
    /**
    * Gets the state
    * Current status of the malware like cleaned/quarantined/allowed etc
    *
    * @return WindowsMalwareState The state
    */
    public function getState()
    {
        if (array_key_exists("state", $this->_propDict)) {
            if (is_a($this->_propDict["state"], "Beta\Microsoft\Graph\Model\WindowsMalwareState")) {
                return $this->_propDict["state"];
            } else {
                $this->_propDict["state"] = new WindowsMalwareState($this->_propDict["state"]);
                return $this->_propDict["state"];
            }
        }
        return null;
    }
    
    /**
    * Sets the state
    * Current status of the malware like cleaned/quarantined/allowed etc
    *
    * @param WindowsMalwareState $val The state
    *
    * @return WindowsDeviceMalwareState
    */
    public function setState($val)
    {
        $this->_propDict["state"] = $val;
        return $this;
    }
    
    /**
    * Gets the threatState
    * Current status of the malware like cleaned/quarantined/allowed etc
    *
    * @return WindowsMalwareThreatState The threatState
    */
    public function getThreatState()
    {
        if (array_key_exists("threatState", $this->_propDict)) {
            if (is_a($this->_propDict["threatState"], "Beta\Microsoft\Graph\Model\WindowsMalwareThreatState")) {
                return $this->_propDict["threatState"];
            } else {
                $this->_propDict["threatState"] = new WindowsMalwareThreatState($this->_propDict["threatState"]);
                return $this->_propDict["threatState"];
            }
        }
        return null;
    }
    
    /**
    * Sets the threatState
    * Current status of the malware like cleaned/quarantined/allowed etc
    *
    * @param WindowsMalwareThreatState $val The threatState
    *
    * @return WindowsDeviceMalwareState
    */
    public function setThreatState($val)
    {
        $this->_propDict["threatState"] = $val;
        return $this;
    }
    
}