<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* WindowsMalwareNameCount File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright © Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Beta\Microsoft\Graph\Model;
/**
* WindowsMalwareNameCount class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright © Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class WindowsMalwareNameCount extends Entity
{
    /**
    * Gets the deviceCount
    * Count of devices with malware dectected for this malware
    *
    * @return int The deviceCount
    */
    public function getDeviceCount()
    {
        if (array_key_exists("deviceCount", $this->_propDict)) {
            return $this->_propDict["deviceCount"];
        } else {
            return null;
        }
    }

    /**
    * Sets the deviceCount
    * Count of devices with malware dectected for this malware
    *
    * @param int $val The value of the deviceCount
    *
    * @return WindowsMalwareNameCount
    */
    public function setDeviceCount($val)
    {
        $this->_propDict["deviceCount"] = $val;
        return $this;
    }

    /**
    * Gets the lastUpdateDateTime
    * The Timestamp of the last update for the device count in UTC
    *
    * @return \DateTime The lastUpdateDateTime
    */
    public function getLastUpdateDateTime()
    {
        if (array_key_exists("lastUpdateDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["lastUpdateDateTime"], "\DateTime")) {
                return $this->_propDict["lastUpdateDateTime"];
            } else {
                $this->_propDict["lastUpdateDateTime"] = new \DateTime($this->_propDict["lastUpdateDateTime"]);
                return $this->_propDict["lastUpdateDateTime"];
            }
        }
        return null;
    }

    /**
    * Sets the lastUpdateDateTime
    * The Timestamp of the last update for the device count in UTC
    *
    * @param \DateTime $val The value to assign to the lastUpdateDateTime
    *
    * @return WindowsMalwareNameCount The WindowsMalwareNameCount
    */
    public function setLastUpdateDateTime($val)
    {
        $this->_propDict["lastUpdateDateTime"] = $val;
         return $this;
    }
    /**
    * Gets the malwareIdentifier
    * The unique identifier. This is malware identifier
    *
    * @return string The malwareIdentifier
    */
    public function getMalwareIdentifier()
    {
        if (array_key_exists("malwareIdentifier", $this->_propDict)) {
            return $this->_propDict["malwareIdentifier"];
        } else {
            return null;
        }
    }

    /**
    * Sets the malwareIdentifier
    * The unique identifier. This is malware identifier
    *
    * @param string $val The value of the malwareIdentifier
    *
    * @return WindowsMalwareNameCount
    */
    public function setMalwareIdentifier($val)
    {
        $this->_propDict["malwareIdentifier"] = $val;
        return $this;
    }
    /**
    * Gets the name
    * Malware name
    *
    * @return string The name
    */
    public function getName()
    {
        if (array_key_exists("name", $this->_propDict)) {
            return $this->_propDict["name"];
        } else {
            return null;
        }
    }

    /**
    * Sets the name
    * Malware name
    *
    * @param string $val The value of the name
    *
    * @return WindowsMalwareNameCount
    */
    public function setName($val)
    {
        $this->_propDict["name"] = $val;
        return $this;
    }
}
